#!/bin/bash
filePath=/tmp
fileRebootPath=/rw
file=Extio3FailCount.txt
RebootCount=0
RestartCount=1
maxRestartCount=2
maxRebootCount=2
servicename=extio3_tx.service


function ResetFpga()
{
    /usr/local/bin/udrvsv2.sh
    /usr/local/bin/MtxFpgaFlasher -fpga 0 -resetbase
    /usr/local/bin/MtxFpgaFlasher -fpga 1 -resetbase

}
function Reboot()
{
    ResetFpga
    let RebootCount++ 
    /bin/echo ${RebootCount} >${fileRebootPath}/${file}
    /bin/echo RestartCount=${RestartCount} > /dev/ttyS0
    /bin/echo RebootCount=${RebootCount} > /dev/ttyS0
    /bin/echo "Rebooting Computer" > /dev/ttyS0

    /bin/date                              >> /rw/logs/RestartCount.log
    /bin/echo RestartCount=${RestartCount} >> /rw/logs/RestartCount.log
    /bin/echo RebootCount=${RebootCount}   >> /rw/logs/RestartCount.log
    /bin/echo "Rebooting..."               >> /rw/logs/RestartCount.log 

    /sbin/reboot     
}
mkdir -p /tmp/previews

if [ -f "${filePath}/${file}" ]; then        #it exists  
        RestartCount=$(/bin/cat ${filePath}/${file}) #create variable RestartCount loading from file
        /bin/echo Current Restart Count=${RestartCount} > /dev/ttyS0 #output current info to ttyS0
    if [ "${RestartCount}" -ge "${maxRestartCount}" ]; then # Verify lower then maxRestartCount
        /bin/echo I hit the max Restart Count=${maxRestartCount} > /dev/ttyS0
        if [ -f "${fileRebootPath}/${file}" ]; then     #verify file reboot exists     
            RebootCount=$(/bin/cat ${fileRebootPath}/${file}) #create variable RebootCount by loading from file
            /bin/echo Current Reboot Count=${RebootCount} > /dev/ttyS0 
            
            if [ "${RebootCount}" -ge "${maxRebootCount}" ]; then # Verify lower then maxRebootCount
                /bin/date                  >> /rw/logs/RestartCount.log
                /bin/echo "Stop rebooting" >> /rw/logs/RestartCount.log
                #/bin/echo "disable ${servicename}" > /dev/ttyS0
                #/bin/touch /rw/boot/mm
                #/bin/rm -f ${fileRebootPath}/${file}
                #/sbin/reboot  
            else
                Reboot         
            fi 
            
        else 
            Reboot  #Doesn't exist increment to 1 from default 0
        fi
        
    else
         let RestartCount++ 
         echo ${RestartCount} >${filePath}/${file}
         
    fi        
else 

    echo ${RestartCount} >${filePath}/${file}

        
fi

/bin/echo End RestartCount=${RestartCount} > /dev/ttyS0
